/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.core.net;

import com.atlassian.sal.api.net.NonMarshallingRequestFactory;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.core.net.AllPortsAuthCache;
import com.atlassian.sal.core.net.HttpClientRequest;
import com.atlassian.sal.core.net.ProxyConfig;
import com.atlassian.sal.core.net.ProxyRoutePlanner;
import com.atlassian.sal.core.net.ProxyUtil;
import com.atlassian.sal.core.net.SystemPropertiesProxyConfig;
import io.atlassian.util.concurrent.LazyReference;
import java.util.function.Supplier;
import org.apache.hc.client5.http.ContextBuilder;
import org.apache.hc.client5.http.auth.AuthCache;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.impl.io.HttpRequestExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientRequestFactory
implements NonMarshallingRequestFactory<HttpClientRequest<?, ?>> {
    private static final Logger log = LoggerFactory.getLogger(HttpClientRequestFactory.class);
    private final Supplier<ProxyConfig> proxyConfigSupplier;

    public HttpClientRequestFactory() {
        this.proxyConfigSupplier = new LazyReference<ProxyConfig>(){

            protected ProxyConfig create() {
                return new SystemPropertiesProxyConfig();
            }
        };
    }

    public HttpClientRequestFactory(ProxyConfig proxyConfig) {
        this.proxyConfigSupplier = () -> proxyConfig;
    }

    public HttpClientRequest createRequest(Request.MethodType methodType, String url) {
        log.debug("Creating HttpClientRequest with proxy config:", (Object)this.proxyConfigSupplier.get());
        CloseableHttpClient httpClient = this.createHttpClient();
        boolean requiresAuthentication = ProxyUtil.requiresAuthentication(this.proxyConfigSupplier.get(), url);
        HttpClientContext clientContext = this.createClientContext(requiresAuthentication);
        return new HttpClientRequest(httpClient, clientContext, methodType, url);
    }

    protected CloseableHttpClient createHttpClient() {
        return HttpClients.custom().useSystemProperties().setRoutePlanner(this.getRoutePlanner()).setRequestExecutor(this.getRequestExecutor()).setConnectionManager(this.getConnectionManager()).setDefaultRequestConfig(RequestConfig.custom().setCookieSpec("relaxed").build()).build();
    }

    protected HttpClientContext createClientContext() {
        return this.createClientContext(this.proxyConfigSupplier.get().requiresAuthentication());
    }

    protected HttpClientContext createClientContext(boolean requiresAuthentication) {
        ContextBuilder contextBuilder = ContextBuilder.create();
        AllPortsAuthCache authCache = new AllPortsAuthCache();
        BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
        ProxyConfig proxyConfig = this.proxyConfigSupplier.get();
        if (requiresAuthentication) {
            HttpHost proxyHost = new HttpHost(proxyConfig.getHost(), proxyConfig.getPort());
            AuthScope proxyAuthScope = new AuthScope(proxyHost);
            UsernamePasswordCredentials proxyCredentials = new UsernamePasswordCredentials(proxyConfig.getUser(), proxyConfig.getPassword().toCharArray());
            basicCredentialsProvider.setCredentials(proxyAuthScope, (Credentials)proxyCredentials);
            BasicScheme proxyScheme = new BasicScheme();
            proxyScheme.initPreemptive((Credentials)proxyCredentials);
            authCache.put(proxyHost, (AuthScheme)proxyScheme);
        }
        contextBuilder.useCredentialsProvider((CredentialsProvider)basicCredentialsProvider);
        contextBuilder.useAuthCache((AuthCache)authCache);
        return contextBuilder.build();
    }

    public boolean supportsHeader() {
        return true;
    }

    protected HttpRoutePlanner getRoutePlanner() {
        return this.proxyConfigSupplier.get().isSet() ? new ProxyRoutePlanner(this.proxyConfigSupplier.get()) : null;
    }

    protected HttpRequestExecutor getRequestExecutor() {
        return null;
    }

    protected HttpClientConnectionManager getConnectionManager() {
        return null;
    }
}

