/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.core.permission;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.annotations.security.SystemAdminOnly;
import com.atlassian.annotations.security.UnlicensedSiteAccess;
import com.atlassian.annotations.security.UnrestrictedAccess;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum AccessType {
    EMPTY(null),
    SYSTEM_ADMIN_ONLY(SystemAdminOnly.class),
    ADMIN_ONLY(AdminOnly.class),
    LICENSED_ONLY(LicensedOnly.class),
    UNLICENSED_SITE_ACCESS(UnlicensedSiteAccess.class),
    ANONYMOUS_SITE_ACCESS(AnonymousSiteAccess.class),
    UNRESTRICTED_ACCESS(UnrestrictedAccess.class);

    private static final Logger log;
    private static final Map<String, AccessType> SECURITY_ANNOTATION_TO_ACCESS_TYPE;
    private final Class<? extends Annotation> annotationType;

    private AccessType(Class<? extends Annotation> annotationType) {
        this.annotationType = annotationType;
    }

    public static AccessType getAccessType(Method method) {
        return AccessType.getAccessType(method, Collections.emptyMap());
    }

    public static AccessType getAccessType(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        Objects.requireNonNull(clazz);
        return AccessType.getAccessTypeInternal(AccessType.getMethod(clazz, methodName, parameterTypes), clazz, Collections.emptyMap());
    }

    public static AccessType getAccessType(Class<?> clazz, String methodName, Map<String, AccessType> additionalMapping, Class<?> ... parameterTypes) {
        Objects.requireNonNull(clazz);
        return AccessType.getAccessTypeInternal(AccessType.getMethod(clazz, methodName, parameterTypes), clazz, additionalMapping);
    }

    @Nullable
    private static Method getMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        Objects.requireNonNull(clazz);
        Method method = null;
        try {
            method = clazz.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            String parameterTypesString = Arrays.stream(parameterTypes).map(Class::getName).collect(Collectors.joining(", "));
            log.debug("The input method: " + methodName + " with parameters: " + parameterTypesString + " not found on input class: " + clazz.getName());
        }
        return method;
    }

    public static AccessType getAccessType(Method method, Map<String, AccessType> additionalMapping) {
        Objects.requireNonNull(method);
        Objects.requireNonNull(additionalMapping);
        return AccessType.getAccessTypeInternal(method, method.getDeclaringClass(), additionalMapping);
    }

    private static AccessType getAccessTypeInternal(Method method, Class<?> clazz, Map<String, AccessType> additionalMapping) {
        Objects.requireNonNull(additionalMapping);
        return Stream.of(() -> method, () -> AccessType.validateNoInheritanceAssumed(clazz, additionalMapping)).map(Supplier::get).filter(Objects::nonNull).map(annotatedElement -> AccessType.extractFromAnnotation(annotatedElement, additionalMapping)).filter(Optional::isPresent).map(Optional::get).findFirst().orElse(EMPTY);
    }

    private static AnnotatedElement validateNoInheritanceAssumed(Class<?> clazz, Map<String, AccessType> additionalMapping) {
        Class<?> currentClass = clazz;
        if (!AccessType.firstValid(clazz.getDeclaredAnnotations(), additionalMapping).isPresent()) {
            for (currentClass = currentClass.getSuperclass(); currentClass != null; currentClass = currentClass.getSuperclass()) {
                Optional<AccessType> accessType = AccessType.firstValid(currentClass.getDeclaredAnnotations(), additionalMapping);
                if (!accessType.isPresent()) continue;
                throw new IllegalStateException("Class " + clazz.getName() + ", which has no security annotation, inherits from " + String.valueOf(currentClass) + ", which has access level set to " + String.valueOf((Object)accessType.get()) + ". A class that extends an annotated class must be explicitly annotated itself to avoid false assumption about annotation inheritance. Add a security annotation to " + String.valueOf(clazz));
            }
        }
        return clazz;
    }

    private static Optional<AccessType> firstValid(Annotation[] annotations, Map<String, AccessType> additionalMapping) {
        return AccessType.streamOfValid(annotations, additionalMapping).findFirst();
    }

    private static Stream<AccessType> streamOfValid(Annotation[] annotations, Map<String, AccessType> additionalMapping) {
        return Arrays.stream(annotations).map(Annotation::annotationType).map(Class::getName).map(key -> Optional.ofNullable(SECURITY_ANNOTATION_TO_ACCESS_TYPE.get(key)).orElseGet(() -> (AccessType)((Object)((Object)((Object)additionalMapping.get(key)))))).filter(Objects::nonNull);
    }

    private static Optional<AccessType> extractFromAnnotation(AnnotatedElement annotatedElement, Map<String, AccessType> additionalMapping) {
        Annotation[] annotations = annotatedElement.getDeclaredAnnotations();
        return AccessType.validateAndReturn(annotations, additionalMapping);
    }

    private static Optional<AccessType> validateAndReturn(Annotation[] annotations, Map<String, AccessType> additionalMapping) {
        return AccessType.streamOfValid(annotations, additionalMapping).reduce((a, b) -> {
            throw new IllegalStateException("Multiple security annotations found: " + String.valueOf(a) + " and " + String.valueOf(b) + ". Only one security annotation is allowed on an element.");
        });
    }

    static {
        log = LoggerFactory.getLogger(AccessType.class);
        SECURITY_ANNOTATION_TO_ACCESS_TYPE = Collections.unmodifiableMap(Arrays.stream(AccessType.values()).filter(accessType -> accessType.annotationType != null).collect(Collectors.toMap(accessType -> accessType.annotationType.getName(), accessType -> accessType)));
    }
}

