/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.core.features;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;

public class SystemDarkFeatureInitializer {
    public static SystemDarkFeatures getSystemStartupDarkFeatures() {
        String propertiesFile = System.getProperty("darkfeatures.properties.file", "atlassian-darkfeatures.properties");
        String disableAllPropertiesFlag = System.getProperty("atlassian.darkfeature.disabled");
        if (Boolean.parseBoolean(disableAllPropertiesFlag)) {
            return SystemDarkFeatures.disableAll();
        }
        Set<String> enabledPropertyDarkFeatures = SystemDarkFeatureInitializer.getPropertyDarkFeaturesWithValue(true);
        Set<String> enabledPropertiesFileDarkFeatures = SystemDarkFeatureInitializer.getPropertiesFileDarkFeatures(propertiesFile, true);
        Set<String> disabledPropertyDarkFeatures = SystemDarkFeatureInitializer.getPropertyDarkFeaturesWithValue(false);
        Set<String> disabledPropertiesFileDarkFeatures = SystemDarkFeatureInitializer.getPropertiesFileDarkFeatures(propertiesFile, false);
        Sets.SetView enabled = Sets.union((Set)Sets.difference(enabledPropertiesFileDarkFeatures, disabledPropertyDarkFeatures), enabledPropertyDarkFeatures);
        Sets.SetView disabled = Sets.union((Set)Sets.difference(disabledPropertiesFileDarkFeatures, enabledPropertyDarkFeatures), disabledPropertyDarkFeatures);
        return SystemDarkFeatures.darkFeatures((Set<String>)enabled, (Set<String>)disabled);
    }

    private static Set<String> getPropertiesFileDarkFeatures(String filename, boolean b) {
        File propertiesFile = new File(filename);
        Properties properties = new Properties();
        try {
            properties.load(new FileReader(propertiesFile));
        }
        catch (IOException e) {
            return Collections.emptySet();
        }
        return new HashSet<String>(SystemDarkFeatureInitializer.getKeysForBooleanValue(SystemDarkFeatureInitializer.filterOnAndStripKeyPrefix(properties), b));
    }

    private static Set<String> getPropertyDarkFeaturesWithValue(boolean b) {
        return new HashSet<String>(SystemDarkFeatureInitializer.getKeysForBooleanValue(SystemDarkFeatureInitializer.filterOnAndStripKeyPrefix(System.getProperties()), b));
    }

    private static Collection<String> getKeysForBooleanValue(Map<Object, Object> properties, Boolean b) {
        return properties.entrySet().stream().filter(entry -> entry.getValue().toString().toLowerCase().matches(b.toString())).map(Map.Entry::getKey).map(Object::toString).collect(Collectors.toList());
    }

    private static Map<Object, Object> filterOnAndStripKeyPrefix(Map<Object, Object> properties) {
        return properties.entrySet().stream().filter(entry -> entry.getKey().toString().startsWith("atlassian.darkfeature.")).collect(Collectors.toMap(entry -> entry.getKey().toString().substring("atlassian.darkfeature.".length()), Map.Entry::getValue));
    }

    public static class SystemDarkFeatures {
        private final Set<String> enabled;
        private final Set<String> disabled;
        private final boolean disableAll;

        private SystemDarkFeatures(Set<String> enabled, Set<String> disabled, boolean disableAll) {
            this.enabled = Collections.unmodifiableSet(enabled);
            this.disabled = Collections.unmodifiableSet(disabled);
            this.disableAll = disableAll;
        }

        public static SystemDarkFeatures disableAll() {
            return new SystemDarkFeatures(Collections.emptySet(), Collections.emptySet(), true);
        }

        public static SystemDarkFeatures darkFeatures(Set<String> enabled, Set<String> disabled) {
            return new SystemDarkFeatures(enabled, disabled, false);
        }

        public Set<String> getEnabled() {
            return this.enabled;
        }

        public Set<String> getDisabled() {
            return this.disabled;
        }

        public boolean isDisableAll() {
            return this.disableAll;
        }
    }
}

