package com.atlassian.sal.core.xsrf;

import jakarta.servlet.http.HttpServletRequest;

import com.atlassian.sal.api.xsrf.XsrfTokenAccessor;
import com.atlassian.sal.api.xsrf.XsrfTokenValidator;
import com.atlassian.security.utils.ConstantTimeComparison;

/**
 * XSRF token validator that manages its own tokens, not using the underlying applications XSRF tokens
 *
 * @since 2.4
 */
public class IndependentXsrfTokenValidator implements XsrfTokenValidator {
    public static final String XSRF_PARAM_NAME = "atl_token";

    private XsrfTokenAccessor accessor;

    public IndependentXsrfTokenValidator(XsrfTokenAccessor accessor) {
        this.accessor = accessor;
    }

    public boolean validateFormEncodedToken(HttpServletRequest request) {
        String parameterToken = request.getParameter(XSRF_PARAM_NAME);
        String requestToken = accessor.getXsrfToken(request, null, false);

        return parameterToken != null
                && requestToken != null
                && ConstantTimeComparison.isEqual(parameterToken, requestToken);
    }

    public String getXsrfParameterName() {
        return XSRF_PARAM_NAME;
    }
}
