/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.core.net;

import com.atlassian.sal.core.net.ProxyConfig;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyUtil {
    private static final Logger log = LoggerFactory.getLogger(ProxyUtil.class);

    static boolean requiresAuthentication(ProxyConfig proxyConfig, String requestUrl) {
        if (proxyConfig.getNonProxyHosts().length != 0 && proxyConfig.requiresAuthentication()) {
            String host = "";
            try {
                host = new URI(requestUrl).getHost();
            }
            catch (URISyntaxException e) {
                log.debug("Can't get host value from {}", (Object)requestUrl);
            }
            try {
                if (StringUtils.isNotEmpty((String)host)) {
                    for (String nonProxyHost : proxyConfig.getNonProxyHosts()) {
                        String pattern = nonProxyHost.replace(".", "\\.").replace("*", ".*").replace("[", "\\[").replace("]", "\\]");
                        if (!host.matches(pattern)) continue;
                        return false;
                    }
                }
            }
            catch (Exception e) {
                log.debug("Failed to match host {} against non proxy hosts {}, defaulting to proxy config for authentication: {}", new Object[]{host, Arrays.toString(proxyConfig.getNonProxyHosts()), e.getMessage()});
            }
        }
        return proxyConfig.requiresAuthentication();
    }
}

