package com.atlassian.sal.core.net;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;

public class ProxyUtil {
    private static final Logger log = LoggerFactory.getLogger(ProxyUtil.class);

    /**
     * Check if proxy configuration requires authentication before sending request to requestUrl
     * @param proxyConfig proxy configuration
     * @param requestUrl url
     * @return true if proxy authentication should be requested before fetching requestUrl
     */
    static boolean requiresAuthentication(final ProxyConfig proxyConfig, final String requestUrl) {
        if (proxyConfig.getNonProxyHosts().length != 0
                && proxyConfig.requiresAuthentication()) {
            String host = "";
            try {
                host = new URI(requestUrl).getHost();
            }
            catch (URISyntaxException e) {
                log.debug("Can't get host value from {}", requestUrl);
            }
            try {
                if (StringUtils.isNotEmpty(host)) {
                    for (String nonProxyHost : proxyConfig.getNonProxyHosts()) {
                        String pattern = nonProxyHost.replace(".", "\\.")
                                .replace("*", ".*")
                                .replace("[", "\\[")
                                .replace("]", "\\]");
                        if (host.matches(pattern)) {
                            return false;
                        }
                    }
                }
            }
            catch (Exception e) {
                log.debug("Failed to match host {} against non proxy hosts {}, defaulting to proxy config for authentication: {}",
                        host, Arrays.toString(proxyConfig.getNonProxyHosts()), e.getMessage());
            }
        }
        return proxyConfig.requiresAuthentication();
    }
}
