/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.core.net;

import com.atlassian.sal.api.net.NonMarshallingRequestFactory;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.core.net.AllPortsAuthCache;
import com.atlassian.sal.core.net.HttpClientRequest;
import com.atlassian.sal.core.net.ProxyConfig;
import com.atlassian.sal.core.net.ProxyRoutePlanner;
import com.atlassian.sal.core.net.SystemPropertiesProxyConfig;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpRequestExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientRequestFactory
implements NonMarshallingRequestFactory<HttpClientRequest<?, ?>> {
    private static final Logger log = LoggerFactory.getLogger(HttpClientRequestFactory.class);
    private final ProxyConfig proxyConfig;

    public HttpClientRequestFactory() {
        this(new SystemPropertiesProxyConfig());
    }

    public HttpClientRequestFactory(ProxyConfig proxyConfig) {
        this.proxyConfig = proxyConfig;
    }

    public HttpClientRequest createRequest(Request.MethodType methodType, String url) {
        log.debug("Creating HttpClientRequest with proxy config:", (Object)this.proxyConfig);
        CloseableHttpClient httpClient = this.createHttpClient();
        HttpClientContext clientContext = this.createClientContext();
        return new HttpClientRequest(httpClient, clientContext, methodType, url);
    }

    protected CloseableHttpClient createHttpClient() {
        return HttpClients.custom().useSystemProperties().setRoutePlanner(this.getRoutePlanner()).setRequestExecutor(this.getRequestExecutor()).setConnectionManager(this.getConnectionManager()).build();
    }

    protected HttpClientContext createClientContext() {
        HttpClientContext httpClientContext = HttpClientContext.create();
        AllPortsAuthCache authCache = new AllPortsAuthCache();
        BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
        if (this.proxyConfig.requiresAuthentication()) {
            HttpHost proxyHost = new HttpHost(this.proxyConfig.getHost(), this.proxyConfig.getPort());
            AuthScope proxyAuthScope = new AuthScope(proxyHost);
            UsernamePasswordCredentials proxyCredentials = new UsernamePasswordCredentials(this.proxyConfig.getUser(), this.proxyConfig.getPassword());
            basicCredentialsProvider.setCredentials(proxyAuthScope, (Credentials)proxyCredentials);
            BasicScheme proxyScheme = new BasicScheme();
            try {
                proxyScheme.processChallenge((Header)new BasicHeader("Proxy-Authenticate", "Basic "));
            }
            catch (MalformedChallengeException e) {
                throw new IllegalStateException(e);
            }
            authCache.put(proxyHost, (AuthScheme)proxyScheme);
        }
        httpClientContext.setCredentialsProvider((CredentialsProvider)basicCredentialsProvider);
        httpClientContext.setAuthCache((AuthCache)authCache);
        return httpClientContext;
    }

    public boolean supportsHeader() {
        return true;
    }

    protected HttpRoutePlanner getRoutePlanner() {
        return this.proxyConfig.isSet() ? new ProxyRoutePlanner(this.proxyConfig) : null;
    }

    protected HttpRequestExecutor getRequestExecutor() {
        return null;
    }

    protected HttpClientConnectionManager getConnectionManager() {
        return null;
    }
}

