/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.core.net;

import com.atlassian.sal.core.net.ProxyConfig;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;

public class SystemPropertiesProxyConfig
implements ProxyConfig {
    public static final String PROXY_HOST_PROPERTY_NAME = "http.proxyHost";
    public static final String PROXY_PORT_PROPERTY_NAME = "http.proxyPort";
    public static final String PROXY_USER_PROPERTY_NAME = "http.proxyUser";
    public static final String PROXY_PASSWORD_PROPERTY_NAME = "http.proxyPassword";
    public static final String PROXY_NON_HOSTS_PROPERTY_NAME = "http.nonProxyHosts";
    public static final int DEFAULT_PROXY_PORT = 80;
    private final String proxyHost = System.getProperty("http.proxyHost");
    private final int proxyPort = Integer.getInteger("http.proxyPort", 80);
    private final String proxyUser = System.getProperty("http.proxyUser");
    private final String proxyPassword = System.getProperty("http.proxyPassword");
    private final String[] nonProxyHosts = System.getProperty("http.nonProxyHosts", "").split("\\|");

    @Override
    public boolean isSet() {
        return StringUtils.isNotBlank((String)this.proxyHost);
    }

    @Override
    public boolean requiresAuthentication() {
        return this.isSet() && StringUtils.isNotBlank((String)this.proxyUser);
    }

    @Override
    public String getHost() {
        return this.proxyHost;
    }

    @Override
    public int getPort() {
        return this.proxyPort;
    }

    @Override
    public String getUser() {
        return this.proxyUser;
    }

    @Override
    public String getPassword() {
        return this.proxyPassword;
    }

    @Override
    public String[] getNonProxyHosts() {
        return this.nonProxyHosts;
    }

    public String toString() {
        return "SystemPropertiesProxyConfig{proxyHost='" + this.proxyHost + '\'' + ", proxyPort=" + this.proxyPort + ", proxyUser='" + this.proxyUser + '\'' + ", proxyPassword='" + this.proxyPassword + '\'' + ", nonProxyHosts=" + Arrays.toString(this.nonProxyHosts) + '}';
    }
}

