/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.core.executor;

import com.atlassian.sal.api.executor.ThreadLocalDelegateExecutorFactory;
import com.atlassian.sal.core.executor.ThreadLocalContextManager;
import com.atlassian.sal.core.executor.ThreadLocalDelegateCallable;
import com.atlassian.sal.core.executor.ThreadLocalDelegateExecutor;
import com.atlassian.sal.core.executor.ThreadLocalDelegateExecutorService;
import com.atlassian.sal.core.executor.ThreadLocalDelegateRunnable;
import com.atlassian.sal.core.executor.ThreadLocalDelegateScheduledExecutorService;
import com.google.common.base.Preconditions;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;

public class DefaultThreadLocalDelegateExecutorFactory<C>
implements ThreadLocalDelegateExecutorFactory {
    private final com.atlassian.sal.api.executor.ThreadLocalContextManager<C> manager;

    protected DefaultThreadLocalDelegateExecutorFactory(com.atlassian.sal.api.executor.ThreadLocalContextManager<C> manager) {
        this.manager = (com.atlassian.sal.api.executor.ThreadLocalContextManager)Preconditions.checkNotNull(manager);
    }

    protected DefaultThreadLocalDelegateExecutorFactory(ThreadLocalContextManager<C> manager) {
        this.manager = (com.atlassian.sal.api.executor.ThreadLocalContextManager)Preconditions.checkNotNull(manager);
    }

    public Executor createExecutor(Executor delegate) {
        return new ThreadLocalDelegateExecutor<C>(this.manager, delegate);
    }

    public ExecutorService createExecutorService(ExecutorService delegate) {
        return new ThreadLocalDelegateExecutorService<C>(this.manager, delegate);
    }

    public ScheduledExecutorService createScheduledExecutorService(ScheduledExecutorService delegate) {
        return new ThreadLocalDelegateScheduledExecutorService<C>(this.manager, delegate);
    }

    public Runnable createRunnable(Runnable delegate) {
        return new ThreadLocalDelegateRunnable<C>(this.manager, delegate);
    }

    public <T> Callable<T> createCallable(Callable<T> delegate) {
        return new ThreadLocalDelegateCallable<C, T>(this.manager, delegate);
    }
}

