/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.core.search.parameter;

import com.atlassian.sal.api.search.parameter.SearchParameter;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.lang.StringUtils;

public class BasicSearchParameter
implements SearchParameter {
    private String name;
    private String value;

    public BasicSearchParameter(String queryString) {
        this.initFromQueryString(queryString);
    }

    public BasicSearchParameter(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String buildQueryString() {
        try {
            return URIUtil.encodeWithinQuery((String)this.name) + "=" + URIUtil.encodeWithinQuery((String)this.value);
        }
        catch (URIException e) {
            throw new RuntimeException(e);
        }
    }

    private void initFromQueryString(String queryString) {
        String[] strings;
        if (StringUtils.isEmpty((String)queryString) || queryString.indexOf("=") == -1) {
            throw new IllegalArgumentException("QueryString '" + queryString + "' does not appear to be a valid query string");
        }
        try {
            strings = URIUtil.decode((String)queryString).split("=");
        }
        catch (URIException e) {
            throw new RuntimeException(e);
        }
        this.name = strings[0];
        this.value = strings[1];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicSearchParameter that = (BasicSearchParameter)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.value.equals(that.value);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }
}

