/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.core.executor;

import com.atlassian.sal.core.executor.ThreadLocalContextManager;
import com.atlassian.sal.core.executor.ThreadLocalDelegateCallable;
import com.atlassian.sal.core.executor.ThreadLocalDelegateExecutorService;
import com.atlassian.sal.core.executor.ThreadLocalDelegateRunnable;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class ThreadLocalDelegateScheduledExecutorService
extends ThreadLocalDelegateExecutorService
implements ScheduledExecutorService {
    private final ScheduledExecutorService delegate;

    public ThreadLocalDelegateScheduledExecutorService(ThreadLocalContextManager manager, ScheduledExecutorService delegate) {
        super(manager, delegate);
        this.delegate = delegate;
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.delegate.schedule(new ThreadLocalDelegateRunnable(this.manager, command), delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.delegate.schedule(new ThreadLocalDelegateCallable<V>(this.manager, callable), delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.delegate.scheduleAtFixedRate(new ThreadLocalDelegateRunnable(this.manager, command), initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.delegate.scheduleWithFixedDelay(new ThreadLocalDelegateRunnable(this.manager, command), initialDelay, delay, unit);
    }
}

