/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.core.usersettings;

import com.atlassian.fugue.Option;
import com.atlassian.sal.api.usersettings.UserSettings;
import com.atlassian.sal.api.usersettings.UserSettingsBuilder;
import com.atlassian.sal.core.usersettings.DefaultUserSettings;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DefaultUserSettingsBuilder
implements UserSettingsBuilder {
    private final Map<String, Object> settings = new HashMap<String, Object>();

    public DefaultUserSettingsBuilder(UserSettings userSettings) {
        for (String key : userSettings.getKeys()) {
            for (Object value : userSettings.getBoolean(key)) {
                this.settings.put(key, value);
            }
            for (Object value : userSettings.getString(key)) {
                this.settings.put(key, value);
            }
            for (Object value : userSettings.getLong(key)) {
                this.settings.put(key, value);
            }
        }
    }

    public DefaultUserSettingsBuilder() {
    }

    public UserSettingsBuilder put(String key, String value) {
        this.settings.put(key, value);
        return this;
    }

    public UserSettingsBuilder put(String key, boolean value) {
        this.settings.put(key, value);
        return this;
    }

    public UserSettingsBuilder put(String key, long value) {
        this.settings.put(key, value);
        return this;
    }

    public UserSettingsBuilder remove(String key) {
        this.settings.remove(key);
        return this;
    }

    public Option<Object> get(String key) {
        return this.settings.containsKey(key) ? Option.some((Object)this.settings.get(key)) : Option.none();
    }

    public Set<String> getKeys() {
        return this.settings.keySet();
    }

    public UserSettings build() {
        return new DefaultUserSettings(this.settings);
    }

    public static UserSettingsBuilder builder() {
        return new DefaultUserSettingsBuilder();
    }

    public static UserSettingsBuilder builder(UserSettings userSettings) {
        return new DefaultUserSettingsBuilder(userSettings);
    }
}

