/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.core.net.auth;

import com.atlassian.sal.core.net.auth.HttpClientAuthenticator;
import com.atlassian.sal.core.trusted.CertificateFactory;
import com.atlassian.security.auth.trustedapps.EncryptedCertificate;
import com.atlassian.security.auth.trustedapps.TrustedApplicationUtils;
import com.atlassian.security.auth.trustedapps.request.TrustedRequest;
import com.atlassian.security.auth.trustedapps.request.commonshttpclient.CommonsHttpClientTrustedRequest;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;

public class TrustedTokenAuthenticator
implements HttpClientAuthenticator {
    private final EncryptedCertificate userCertificate;

    public TrustedTokenAuthenticator(String username, String url, CertificateFactory certificateFactory) {
        this.userCertificate = username != null && !username.equals("") ? certificateFactory.createCertificate(username, url) : null;
    }

    @Override
    public void process(HttpClient httpClient, HttpMethod method) {
        CommonsHttpClientTrustedRequest request = new CommonsHttpClientTrustedRequest(method);
        TrustedApplicationUtils.addRequestParameters((EncryptedCertificate)this.userCertificate, (TrustedRequest)request);
    }
}

