/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.core.executor;

import com.atlassian.sal.core.executor.ThreadLocalContextManager;

class ThreadLocalDelegateRunnable
implements Runnable {
    private final Object context;
    private final Runnable delegate;
    private final ThreadLocalContextManager manager;
    private final ClassLoader contextClassLoader;

    ThreadLocalDelegateRunnable(ThreadLocalContextManager manager, Runnable delegate) {
        this.delegate = delegate;
        this.manager = manager;
        this.context = manager.getThreadLocalContext();
        this.contextClassLoader = Thread.currentThread().getContextClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.contextClassLoader);
            this.manager.setThreadLocalContext(this.context);
            this.delegate.run();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextClassLoader);
            this.manager.clearThreadLocalContext();
        }
    }
}

