/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.core.executor;

import com.atlassian.sal.api.executor.ThreadLocalDelegateExecutorFactory;
import com.atlassian.sal.core.executor.ThreadLocalContextManager;
import com.atlassian.sal.core.executor.ThreadLocalDelegateCallable;
import com.atlassian.sal.core.executor.ThreadLocalDelegateExecutor;
import com.atlassian.sal.core.executor.ThreadLocalDelegateExecutorService;
import com.atlassian.sal.core.executor.ThreadLocalDelegateRunnable;
import com.atlassian.sal.core.executor.ThreadLocalDelegateScheduledExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;

public class DefaultThreadLocalDelegateExecutorFactory
implements ThreadLocalDelegateExecutorFactory {
    private final ThreadLocalContextManager manager;

    protected DefaultThreadLocalDelegateExecutorFactory(ThreadLocalContextManager manager) {
        this.manager = manager;
    }

    public Executor createExecutor(Executor delegate) {
        return new ThreadLocalDelegateExecutor(this.manager, delegate);
    }

    public ExecutorService createExecutorService(ExecutorService delegate) {
        return new ThreadLocalDelegateExecutorService(this.manager, delegate);
    }

    public ScheduledExecutorService createScheduledExecutorService(ScheduledExecutorService delegate) {
        return new ThreadLocalDelegateScheduledExecutorService(this.manager, delegate);
    }

    public Runnable createRunnable(Runnable delegate) {
        return new ThreadLocalDelegateRunnable(this.manager, delegate);
    }

    public <T> Callable<T> createCallable(Callable<T> delegate) {
        return new ThreadLocalDelegateCallable<T>(this.manager, delegate);
    }
}

