/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.core.component;

import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.spi.HostContextAccessor;
import java.util.Collection;
import java.util.Map;
import org.apache.log4j.Logger;

public class DefaultComponentLocator
extends ComponentLocator {
    private final HostContextAccessor hostContextAccessor;
    private static final Logger log = Logger.getLogger(DefaultComponentLocator.class);

    public DefaultComponentLocator(HostContextAccessor accessor) {
        this.hostContextAccessor = accessor;
        ComponentLocator.setComponentLocator((ComponentLocator)this);
    }

    protected <T> T getComponentInternal(Class<T> iface) {
        Map beansOfType = this.hostContextAccessor.getComponentsOfType(iface);
        if (beansOfType == null || beansOfType.isEmpty()) {
            return null;
        }
        if (beansOfType.size() > 1) {
            String shortClassName = this.convertClassToName(iface);
            Object implementation = beansOfType.get(shortClassName);
            if (implementation == null) {
                log.warn((Object)("More than one instance of " + iface.getName() + " found but none of them has key " + shortClassName));
            }
            return (T)implementation;
        }
        return (T)beansOfType.values().iterator().next();
    }

    protected <T> T getComponentInternal(Class<T> iface, String componentId) {
        Map beansOfType = this.hostContextAccessor.getComponentsOfType(iface);
        return (T)beansOfType.get(componentId);
    }

    protected <T> Collection<T> getComponentsInternal(Class<T> iface) {
        Map beansOfType = this.hostContextAccessor.getComponentsOfType(iface);
        return beansOfType != null ? beansOfType.values() : null;
    }
}

