/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.core.upgrade;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.upgrade.PluginUpgradeManager;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.atlassian.sal.core.upgrade.PluginUpgrader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPluginUpgradeManager
implements PluginUpgradeManager,
LifecycleAware {
    private static final Logger log = Logger.getLogger(DefaultPluginUpgradeManager.class);
    private final List<PluginUpgradeTask> upgradeTasks;
    private final TransactionTemplate transactionTemplate;
    private final PluginAccessor pluginAccessor;
    private final PluginSettingsFactory pluginSettingsFactory;

    public DefaultPluginUpgradeManager(List<PluginUpgradeTask> upgradeTasks, TransactionTemplate transactionTemplate, PluginAccessor pluginAccessor, PluginSettingsFactory pluginSettingsFactory) {
        this.upgradeTasks = upgradeTasks;
        this.transactionTemplate = transactionTemplate;
        this.pluginAccessor = pluginAccessor;
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    @Deprecated
    public void onBind(PluginUpgradeTask task, Map props) {
        log.debug((Object)("onbind task = [" + task.getPluginKey() + ", " + task.getBuildNumber() + "] "));
    }

    public void onStart() {
        log.debug((Object)"onStart");
        List<Message> messages = this.upgrade();
        if (messages != null) {
            for (Message msg : messages) {
                log.error((Object)("Upgrade error: " + msg));
            }
        }
    }

    protected Map<String, List<PluginUpgradeTask>> getUpgradeTasks() {
        HashMap<String, List<PluginUpgradeTask>> pluginUpgrades = new HashMap<String, List<PluginUpgradeTask>>();
        for (PluginUpgradeTask upgradeTask : this.upgradeTasks) {
            ArrayList<PluginUpgradeTask> upgrades = (ArrayList<PluginUpgradeTask>)pluginUpgrades.get(upgradeTask.getPluginKey());
            if (upgrades == null) {
                upgrades = new ArrayList<PluginUpgradeTask>();
                pluginUpgrades.put(upgradeTask.getPluginKey(), upgrades);
            }
            upgrades.add(upgradeTask);
        }
        return pluginUpgrades;
    }

    public List<Message> upgrade() {
        List messages = (List)this.transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction() {
                return DefaultPluginUpgradeManager.this.upgradeInternal();
            }
        });
        return messages;
    }

    public List<Message> upgradeInternal() {
        log.info((Object)"Running plugin upgrade tasks...");
        Map<String, List<PluginUpgradeTask>> pluginUpgrades = this.getUpgradeTasks();
        ArrayList<Message> messages = new ArrayList<Message>();
        for (String pluginKey : pluginUpgrades.keySet()) {
            List<PluginUpgradeTask> upgrades = pluginUpgrades.get(pluginKey);
            Plugin plugin = this.pluginAccessor.getPlugin(pluginKey);
            if (plugin == null) {
                throw new IllegalArgumentException("Invalid plugin key: " + pluginKey);
            }
            PluginUpgrader pluginUpgrader = new PluginUpgrader(plugin, this.pluginSettingsFactory.createGlobalSettings(), upgrades);
            List<Message> upgradeMessages = pluginUpgrader.upgrade();
            if (upgradeMessages == null) continue;
            messages.addAll(upgradeMessages);
        }
        return messages;
    }
}

