/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.core.net;

import com.atlassian.sal.api.net.Whitelist;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.net.URI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingWhitelist
implements Whitelist {
    private final Iterable<Whitelist> whitelists;

    public DelegatingWhitelist(Iterable<Whitelist> whitelists) {
        this.whitelists = (Iterable)Preconditions.checkNotNull(whitelists, (Object)"whitelists");
    }

    public boolean allows(URI uri) {
        return Iterables.any(this.whitelists, this.allowsP((URI)Preconditions.checkNotNull((Object)uri, (Object)"uri")));
    }

    private Predicate<Whitelist> allowsP(URI uri) {
        return new WhitelistAllows(uri);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class WhitelistAllows
    implements Predicate<Whitelist> {
        private final URI uri;

        public WhitelistAllows(URI uri) {
            this.uri = uri;
        }

        public boolean apply(Whitelist whitelist) {
            return whitelist.allows(this.uri);
        }
    }
}

