/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.core.net.auth;

import com.atlassian.sal.core.net.auth.HttpClientAuthenticator;
import com.atlassian.sal.core.trusted.CertificateFactory;
import com.atlassian.security.auth.trustedapps.EncryptedCertificate;
import com.atlassian.security.auth.trustedapps.TrustedApplicationUtils;
import com.atlassian.security.auth.trustedapps.request.TrustedRequest;
import com.atlassian.security.auth.trustedapps.request.commonshttpclient.CommonsHttpClientTrustedRequest;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.lang.StringUtils;

public class TrustedTokenAuthenticator
implements HttpClientAuthenticator {
    private final EncryptedCertificate userCertificate;

    public TrustedTokenAuthenticator(String username, String url, CertificateFactory certificateFactory) {
        this.userCertificate = StringUtils.isNotBlank((String)username) && StringUtils.isNotBlank((String)url) ? certificateFactory.createCertificate(username, url) : null;
    }

    @Override
    public void process(HttpClient httpClient, HttpMethod method) {
        if (this.userCertificate != null) {
            CommonsHttpClientTrustedRequest request = new CommonsHttpClientTrustedRequest(method);
            TrustedApplicationUtils.addRequestParameters((EncryptedCertificate)this.userCertificate, (TrustedRequest)request);
        }
    }
}

