/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.core.lifecycle;

import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.sal.api.lifecycle.LifecycleManager;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultLifecycleManager
implements LifecycleManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultLifecycleManager.class);
    private boolean started = false;
    private List<LifecycleAware> listeners;
    private final PluginEventManager pluginEventManager;

    public DefaultLifecycleManager(PluginEventManager pluginEventManager) {
        this.pluginEventManager = pluginEventManager;
        pluginEventManager.register((Object)this);
    }

    @PluginEventListener
    public void onFrameworkStart(PluginFrameworkStartedEvent event) {
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() {
        if (!this.started && this.isApplicationSetUp()) {
            try {
                this.notifyOnStart();
            }
            finally {
                this.started = true;
            }
        }
    }

    public synchronized void onBind(LifecycleAware service, Map properties) {
        if (this.started) {
            this.notifyLifecycleAwareOfStart(service);
        }
    }

    public void destroy() {
        this.pluginEventManager.unregister((Object)this);
    }

    protected void notifyOnStart() {
        Validate.notNull(this.listeners, (String)"The list of LifecycleAware implementations hasn't been set yet and so the manager cannot start.");
        for (LifecycleAware entry : this.listeners) {
            this.notifyLifecycleAwareOfStart(entry);
        }
    }

    private void notifyLifecycleAwareOfStart(LifecycleAware entry) {
        try {
            entry.onStart();
        }
        catch (RuntimeException ex) {
            log.error("Unable to start component: " + entry.getClass().getName(), (Throwable)ex);
        }
    }

    public void setLifecycleAwareListeners(List<LifecycleAware> listeners) {
        this.listeners = listeners;
    }
}

