/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.core.executor;

import com.atlassian.sal.api.executor.ThreadLocalContextManager;
import com.atlassian.sal.core.executor.ThreadLocalDelegateCallable;
import com.atlassian.sal.core.executor.ThreadLocalDelegateExecutorService;
import com.atlassian.sal.core.executor.ThreadLocalDelegateRunnable;
import com.google.common.base.Preconditions;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class ThreadLocalDelegateScheduledExecutorService<C>
extends ThreadLocalDelegateExecutorService<C>
implements ScheduledExecutorService {
    private final ScheduledExecutorService delegate;

    public ThreadLocalDelegateScheduledExecutorService(ThreadLocalContextManager<C> manager, ScheduledExecutorService delegate) {
        super((ThreadLocalContextManager)Preconditions.checkNotNull(manager), (ExecutorService)Preconditions.checkNotNull((Object)delegate));
        this.delegate = delegate;
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.delegate.schedule(new ThreadLocalDelegateRunnable(this.manager, command), delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.delegate.schedule(new ThreadLocalDelegateCallable(this.manager, callable), delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.delegate.scheduleAtFixedRate(new ThreadLocalDelegateRunnable(this.manager, command), initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.delegate.scheduleWithFixedDelay(new ThreadLocalDelegateRunnable(this.manager, command), initialDelay, delay, unit);
    }
}

