/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.core.features;

import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.sal.api.features.EnabledDarkFeatures;
import com.atlassian.sal.api.features.EnabledDarkFeaturesBuilder;
import com.atlassian.sal.api.features.MissingPermissionException;
import com.atlassian.sal.api.features.SiteDarkFeaturesStorage;
import com.atlassian.sal.api.features.ValidFeatureKeyPredicate;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.core.features.SystemDarkFeatureInitializer;
import java.util.Set;
import javax.annotation.Nullable;

public class DefaultDarkFeatureManager
implements DarkFeatureManager {
    private final UserManager userManager;
    private final SiteDarkFeaturesStorage siteDarkFeaturesStorage;
    private final SystemDarkFeatureInitializer.SystemDarkFeatures systemDarkFeatures;

    public DefaultDarkFeatureManager(UserManager userManager, SiteDarkFeaturesStorage siteDarkFeaturesStorage) {
        this.userManager = userManager;
        this.siteDarkFeaturesStorage = siteDarkFeaturesStorage;
        this.systemDarkFeatures = SystemDarkFeatureInitializer.getSystemStartupDarkFeatures();
    }

    public boolean isFeatureEnabledForAllUsers(String featureKey) {
        return ValidFeatureKeyPredicate.isValidFeatureKey((String)featureKey) && this.getFeaturesEnabledForAllUsers().isFeatureEnabled(featureKey);
    }

    public boolean isFeatureEnabledForCurrentUser(String featureKey) {
        return this.isFeatureEnabledForAllUsers(featureKey);
    }

    public boolean isFeatureEnabledForUser(@Nullable UserKey userKey, String featureKey) {
        if (this.isUserAnonymous(userKey) || this.isUserExisting(userKey)) {
            return this.isFeatureEnabledForAllUsers(featureKey);
        }
        throw new IllegalArgumentException("The user does not exist");
    }

    public boolean canManageFeaturesForAllUsers() {
        try {
            UserKey remoteUserKey = this.userManager.getRemoteUserKey();
            return this.userManager.isSystemAdmin(remoteUserKey);
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public void enableFeatureForAllUsers(String featureKey) {
        ValidFeatureKeyPredicate.checkFeatureKey((String)featureKey);
        this.checkCurrentUserCanManageFeaturesForAllUsers();
        this.siteDarkFeaturesStorage.enable(featureKey);
    }

    public void disableFeatureForAllUsers(String featureKey) {
        ValidFeatureKeyPredicate.checkFeatureKey((String)featureKey);
        this.checkCurrentUserCanManageFeaturesForAllUsers();
        this.siteDarkFeaturesStorage.disable(featureKey);
    }

    public void enableFeatureForCurrentUser(String featureKey) {
        this.throwUnsupportedPerUserOperationException();
    }

    public void enableFeatureForUser(UserKey userKey, String featureKey) {
        this.throwUnsupportedPerUserOperationException();
    }

    public void disableFeatureForCurrentUser(String featureKey) {
        this.throwUnsupportedPerUserOperationException();
    }

    public void disableFeatureForUser(UserKey userKey, String featureKey) {
        this.throwUnsupportedPerUserOperationException();
    }

    public EnabledDarkFeatures getFeaturesEnabledForAllUsers() {
        if (this.systemDarkFeatures.isDisableAll()) {
            return EnabledDarkFeatures.NONE;
        }
        return new EnabledDarkFeaturesBuilder().unmodifiableFeaturesEnabledForAllUsers(this.systemDarkFeatures.getEnabled()).featuresEnabledForAllUsers((Set)this.siteDarkFeaturesStorage.getEnabledDarkFeatures()).build();
    }

    public EnabledDarkFeatures getFeaturesEnabledForCurrentUser() {
        return this.getFeaturesEnabledForAllUsers();
    }

    public EnabledDarkFeatures getFeaturesEnabledForUser(@Nullable UserKey userKey) {
        if (this.isUserAnonymous(userKey) || this.isUserExisting(userKey)) {
            return this.getFeaturesEnabledForAllUsers();
        }
        throw new IllegalArgumentException("The user does not exist");
    }

    private boolean isUserExisting(@Nullable UserKey userKey) {
        return userKey != null && this.userManager.getUserProfile(userKey) != null;
    }

    private boolean isUserAnonymous(@Nullable UserKey userKey) {
        return userKey == null;
    }

    private void checkCurrentUserCanManageFeaturesForAllUsers() {
        if (!this.canManageFeaturesForAllUsers()) {
            throw new MissingPermissionException("The current user is not allowed to change dark features affecting all users.");
        }
    }

    private void throwUnsupportedPerUserOperationException() {
        throw new UnsupportedOperationException("The default implementation doesn't support per-user dark features.");
    }
}

