package com.atlassian.sal.core.net.auth;

import com.atlassian.sal.core.trusted.CertificateFactory;
import com.atlassian.security.auth.trustedapps.EncryptedCertificate;
import com.atlassian.security.auth.trustedapps.TrustedApplicationUtils;
import com.atlassian.security.auth.trustedapps.request.TrustedRequest;
import com.atlassian.security.auth.trustedapps.request.commonshttpclient.CommonsHttpClientTrustedRequest;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.lang.StringUtils;

public class TrustedTokenAuthenticator implements HttpClientAuthenticator
{
    private final EncryptedCertificate userCertificate;

    public TrustedTokenAuthenticator(String username, String url, CertificateFactory certificateFactory)
    {
        if (StringUtils.isNotBlank(username) && StringUtils.isNotBlank(url))
        {
            this.userCertificate = certificateFactory.createCertificate(username, url);
        } else
        {
            this.userCertificate = null;
        }
    }

    /**
     * @param httpClient The client to process
     * @param method The method type
     */
    public void process(HttpClient httpClient, HttpMethod method)
    {
        if(this.userCertificate != null)
        {
            TrustedRequest request = new CommonsHttpClientTrustedRequest(method);
            TrustedApplicationUtils.addRequestParameters(this.userCertificate, request);
        }
    }

}
