package com.atlassian.sal.core.net;

import java.net.URI;

import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpsURL;
import org.apache.commons.httpclient.protocol.Protocol;

class HttpClientProtocolConfig
{
    /**
     * Configures httpClient to use the default SSL protocols for the given url
     *
     * @param httpClient httpClient to configure
     * @param url url to use the protocols with
     */
    static void configureProtocol(final HttpClient httpClient, final String url)
    {
        changeHostConfigurationProtocol(httpClient, url, CustomSSLProtocolSocketFactory.DEFAULT_PROTOCOLS);
    }

    /**
     * Change httpClient protocol configuration to use different ssl protocols.
     * The httpClient must have been configured before using the configureProtocol method.
     *
     * @param httpClient httpClient to configure
     * @param sslProtocols url to use the protocols with
     */
    static void changeHostConfigurationProtocol(final HttpClient httpClient, final String sslProtocols)
    {
        final HostConfiguration hostConfiguration = httpClient.getHostConfiguration();

        String host = hostConfiguration.getHost();
        int port = hostConfiguration.getPort();
        String scheme = hostConfiguration.getProtocol().getScheme();

        changeHostConfigurationProtocol(hostConfiguration, host, port, scheme, sslProtocols);
    }

    private static void changeHostConfigurationProtocol(final HttpClient httpClient, final String remoteUrl, final String sslProtocols)
    {
        URI url = URI.create(remoteUrl);
        String host = url.getHost();
        int port = url.getPort();
        String scheme = url.getScheme();

        changeHostConfigurationProtocol(httpClient.getHostConfiguration(), host, port, scheme, sslProtocols);
    }

    private static void changeHostConfigurationProtocol(HostConfiguration hostConfiguration, String host, int port, String scheme, String sslProtocols)
    {
        if ("https".equals(scheme))
        {
            Protocol customHttpsProtocol = new Protocol("https", new CustomSSLProtocolSocketFactory(sslProtocols), HttpsURL.DEFAULT_PORT);
            hostConfiguration.setHost(host, port, customHttpsProtocol);
        } else
        {
            hostConfiguration.setHost(host, port);
        }
    }
}
