/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.core.features;

import com.atlassian.fugue.Option;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.core.features.SystemDarkFeatureInitializer;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Set;

public class DefaultDarkFeatureManager
implements DarkFeatureManager {
    private final Set<String> enabledFeatureKeys;
    private final UserManager userManager;

    public DefaultDarkFeatureManager(UserManager userManager) {
        this.userManager = userManager;
        SystemDarkFeatureInitializer.SystemDarkFeatures systemDarkFeatures = SystemDarkFeatureInitializer.getSystemStartupDarkFeatures();
        this.enabledFeatureKeys = systemDarkFeatures.isDisableAll() ? Collections.emptySet() : ImmutableSet.copyOf(systemDarkFeatures.getEnabled());
    }

    public boolean isSystemFeatureEnabled(String key) {
        return this.enabledFeatureKeys.contains(key);
    }

    public boolean isUserFeatureEnabled(String key) {
        return this.isSystemFeatureEnabled(key);
    }

    public Option<Boolean> isUserFeatureEnabledForUser(String username, String key) {
        return this.userManager.resolve(username) == null ? Option.none() : Option.some((Object)this.isSystemFeatureEnabled(key));
    }

    public Set<String> getAllEnabledFeaturesForCurrentUser() {
        return this.enabledFeatureKeys;
    }

    public Option<Set<String>> getAllEnanbedFeaturesForUser(String username) {
        return this.userManager.resolve(username) == null ? Option.none() : Option.some(this.getAllEnabledFeaturesForCurrentUser());
    }
}

