/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.core.scheduling;

import com.atlassian.sal.api.scheduling.PluginJob;
import com.atlassian.sal.api.scheduling.PluginScheduler;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimerPluginScheduler
implements PluginScheduler {
    private Map<String, Timer> tasks = Collections.synchronizedMap(new HashMap());

    public synchronized void scheduleJob(String name, Class<? extends PluginJob> job, Map<String, Object> jobDataMap, Date startTime, long repeatInterval) {
        Timer timer = this.tasks.get(name);
        if (timer != null) {
            timer.cancel();
        }
        timer = new Timer("PluginSchedulerTask-" + name);
        this.tasks.put(name, timer);
        PluginTimerTask task = new PluginTimerTask();
        task.setJobClass(job);
        task.setJobDataMap(jobDataMap);
        timer.scheduleAtFixedRate((TimerTask)task, startTime, repeatInterval);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PluginTimerTask
    extends TimerTask {
        private Class<? extends PluginJob> jobClass;
        private Map jobDataMap;
        private static final Logger log = Logger.getLogger(PluginTimerTask.class);

        private PluginTimerTask() {
        }

        @Override
        public void run() {
            PluginJob job;
            try {
                job = this.jobClass.newInstance();
            }
            catch (InstantiationException ie) {
                log.error((Object)"Error instantiating job", (Throwable)ie);
                return;
            }
            catch (IllegalAccessException iae) {
                log.error((Object)"Cannot access job class", (Throwable)iae);
                return;
            }
            job.execute(this.jobDataMap);
        }

        public Class<? extends PluginJob> getJobClass() {
            return this.jobClass;
        }

        public void setJobClass(Class<? extends PluginJob> jobClass) {
            this.jobClass = jobClass;
        }

        public Map getJobDataMap() {
            return this.jobDataMap;
        }

        public void setJobDataMap(Map jobDataMap) {
            this.jobDataMap = jobDataMap;
        }
    }
}

