/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.core.upgrade;

import com.atlassian.plugin.Plugin;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.atlassian.sal.core.message.DefaultMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginUpgrader {
    public static final String BUILD = ":build";
    protected List<PluginUpgradeTask> upgradeTasks = new ArrayList<PluginUpgradeTask>();
    private static final Logger log = Logger.getLogger(PluginUpgrader.class);
    protected Plugin plugin;
    protected PluginSettings pluginSettings;
    protected List<Message> errors = new ArrayList<Message>();
    private static final Comparator<PluginUpgradeTask> UPGRADE_TASK_COMPARATOR = new Comparator<PluginUpgradeTask>(){

        @Override
        public int compare(PluginUpgradeTask t1, PluginUpgradeTask t2) {
            if (t1 == null) {
                return -1;
            }
            if (t2 == null) {
                return 1;
            }
            if (t1.getBuildNumber() > t2.getBuildNumber()) {
                return 1;
            }
            return t1.getBuildNumber() < t2.getBuildNumber() ? -1 : 0;
        }
    };

    protected PluginUpgrader(Plugin plugin, PluginSettings pluginSettings, List<PluginUpgradeTask> upgradeTasks) {
        this.plugin = plugin;
        this.pluginSettings = pluginSettings;
        this.upgradeTasks = upgradeTasks;
        Collections.sort(this.upgradeTasks, UPGRADE_TASK_COMPARATOR);
    }

    protected List<Message> upgrade() {
        if (this.needUpgrade()) {
            this.doUpgrade();
        }
        return this.errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doUpgrade() {
        try {
            log.info((Object)("Upgrading plugin " + this.plugin.getKey()));
            for (PluginUpgradeTask upgradeTask : this.upgradeTasks) {
                if (upgradeTask.getBuildNumber() <= this.getDataBuildNumber()) continue;
                Collection messages = upgradeTask.doUpgrade();
                if (messages == null || messages.isEmpty()) {
                    this.upgradeTaskSucceeded(upgradeTask);
                    continue;
                }
                this.upgradeTaskFailed(upgradeTask, messages);
            }
        }
        catch (Throwable e) {
            this.errors.add(new DefaultMessage("upgrade.unexpected.exception", e));
            log.error((Object)("Upgrade failed: " + e.getMessage()), e);
        }
        finally {
            this.postUpgrade();
        }
    }

    protected void upgradeTaskSucceeded(PluginUpgradeTask upgradeTask) {
        this.setDataBuildNumber(upgradeTask.getBuildNumber());
        log.info((Object)("Upgraded plugin " + upgradeTask.getPluginKey() + " to version " + upgradeTask.getBuildNumber() + " - " + upgradeTask.getShortDescription()));
    }

    protected void upgradeTaskFailed(PluginUpgradeTask upgradeTask, Collection<Message> messages) {
        this.errors.addAll(messages);
        StringBuilder msg = new StringBuilder();
        msg.append("Plugin upgrade failed for ").append(upgradeTask.getPluginKey());
        msg.append(" to version ").append(upgradeTask.getBuildNumber());
        msg.append(" - ").append(upgradeTask.getShortDescription());
        msg.append("\n");
        for (Message message : messages) {
            msg.append("\t* ").append(message.getKey()).append(" ").append(Arrays.toString(message.getArguments()));
        }
        log.warn((Object)msg.toString());
    }

    protected List<Message> getErrors() {
        return this.errors;
    }

    protected boolean needUpgrade() {
        PluginUpgradeTask lastUpgradeTask = this.upgradeTasks.get(this.upgradeTasks.size() - 1);
        return lastUpgradeTask.getBuildNumber() > this.getDataBuildNumber();
    }

    protected int getDataBuildNumber() {
        String val = (String)this.pluginSettings.get(this.plugin.getKey() + BUILD);
        if (val != null) {
            return Integer.parseInt(val);
        }
        return 0;
    }

    protected void setDataBuildNumber(int buildNumber) {
        this.pluginSettings.put(this.plugin.getKey() + BUILD, (Object)String.valueOf(buildNumber));
    }

    protected void postUpgrade() {
        log.info((Object)("Plugin " + this.plugin.getKey() + " upgrade completed. Current version is: " + this.getDataBuildNumber()));
    }
}

