/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.api.net;

import com.atlassian.sal.api.net.HttpClientRequest;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.RequestFactory;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClientRequestFactory
implements RequestFactory<HttpClientRequest> {
    private static final Logger log = Logger.getLogger(HttpClientRequestFactory.class);
    public static final int DEFAULT_SOCKET_TIMEOUT = Integer.parseInt(System.getProperty("http.socketTimeout", "10000"));
    public static final int DEFAULT_CONNECTION_TIMEOUT = Integer.parseInt(System.getProperty("http.connectionTimeout", "10000"));

    public HttpClientRequest createRequest(Request.MethodType methodType, String url) {
        HttpClient httpClient = this.getHttpClient(url);
        return new HttpClientRequest(httpClient, methodType, url);
    }

    protected HttpClient getHttpClient(String url) {
        HttpClient httpClient = new HttpClient();
        this.configureProxy(httpClient, url);
        this.configureConnectionParameters(httpClient);
        return httpClient;
    }

    protected void configureConnectionParameters(HttpClient httpClient) {
        HttpConnectionManagerParams params = httpClient.getHttpConnectionManager().getParams();
        params.setSoTimeout(DEFAULT_SOCKET_TIMEOUT);
        params.setConnectionTimeout(DEFAULT_CONNECTION_TIMEOUT);
    }

    protected void configureProxy(HttpClient client, String remoteUrl) {
        URI uri;
        String proxyHost = System.getProperty("http.proxyHost");
        try {
            uri = new URI(remoteUrl);
        }
        catch (URISyntaxException e) {
            log.warn((Object)("Invalid url: " + remoteUrl), (Throwable)e);
            return;
        }
        if (proxyHost != null && !this.isNonProxyHost(uri.getHost())) {
            int port = 80;
            try {
                port = Integer.parseInt(System.getProperty("http.proxyPort", "80"));
            }
            catch (NumberFormatException e) {
                log.warn((Object)"System property 'http.proxyPort' is not a number. Defaulting to 80.");
            }
            client.getHostConfiguration().setProxy(proxyHost, port);
            if (this.proxyAuthenticationRequired()) {
                client.getState().setProxyCredentials(new AuthScope(proxyHost, port), (Credentials)new UsernamePasswordCredentials(System.getProperty("http.proxyUser"), System.getProperty("http.proxyPassword")));
            }
        }
    }

    private boolean proxyAuthenticationRequired() {
        return System.getProperty("http.proxyUser") != null;
    }

    private boolean isNonProxyHost(String host) {
        String[] nonProxyHosts;
        String httpNonProxyHosts = System.getProperty("http.nonProxyHosts");
        if (StringUtils.isBlank((String)httpNonProxyHosts)) {
            if (StringUtils.isBlank((String)System.getProperty("http.nonProxyHost"))) {
                log.warn((Object)"The system property http.nonProxyHost is set. You probably meant to set http.nonProxyHosts.");
            }
            return false;
        }
        for (String nonProxyHost : nonProxyHosts = httpNonProxyHosts.split("\\|")) {
            if (!(nonProxyHost.startsWith("*") ? host.endsWith(nonProxyHost.substring(1)) : host.equals(nonProxyHost))) continue;
            return true;
        }
        return false;
    }
}

