/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.api.component;

import com.atlassian.sal.api.component.ComponentLocator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockComponentLocator
extends ComponentLocator {
    Map<Class, Object> components = new HashMap<Class, Object>();

    public MockComponentLocator(Object ... objects) {
        if (objects != null && objects.length > 0) {
            for (Object o : objects) {
                this.add(o);
            }
        }
    }

    public MockComponentLocator add(Class cls, Object obj) {
        this.components.put(cls, obj);
        return this;
    }

    public MockComponentLocator add(Object obj) {
        ArrayList interfaces = new ArrayList();
        for (Class<?> cls = obj.getClass(); cls != null; cls = cls.getSuperclass()) {
            interfaces.addAll(Arrays.asList(cls.getInterfaces()));
        }
        this.components.put((Class)interfaces.get(0), obj);
        return this;
    }

    protected <T> T getComponentInternal(Class<T> iface) {
        return (T)this.components.get(iface);
    }

    public static MockComponentLocator create(Object ... objects) {
        MockComponentLocator mockComponentLocator = new MockComponentLocator(objects);
        ComponentLocator.setComponentLocator((ComponentLocator)mockComponentLocator);
        return mockComponentLocator;
    }

    protected <T> Collection<T> getComponentsInternal(Class<T> iface) {
        return null;
    }

    protected <T> T getComponentInternal(Class<T> iface, String componentId) {
        return this.getComponentInternal(iface);
    }
}

