/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.api.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class PropertiesLoader {
    private static final Logger log = Logger.getLogger(PropertiesLoader.class);

    public static Properties loadProperties(String propertiesName) {
        String propertiesKey = propertiesName + ".location";
        String propertiesLocation = System.getProperty(propertiesKey);
        Properties properties = new Properties();
        if (StringUtils.isNotEmpty((String)propertiesLocation)) {
            try {
                properties.load(new FileInputStream(propertiesLocation));
            }
            catch (IOException e) {
                log.error((Object)("Error reading " + propertiesName + " from location '" + propertiesLocation + "'. Trying to load from classpath instead..."), (Throwable)e);
                PropertiesLoader.loadPropertiesFromClasspath(propertiesName, properties);
            }
        } else {
            PropertiesLoader.loadPropertiesFromClasspath(propertiesName, properties);
        }
        return properties;
    }

    private static void loadPropertiesFromClasspath(String propertiesName, Properties properties) {
        try {
            properties.load(PropertiesLoader.getResourceAsStream(propertiesName, PropertiesLoader.class));
        }
        catch (Exception e) {
            log.error((Object)("Error loading " + propertiesName + " properties from classpath."), (Throwable)e);
        }
    }

    private static InputStream getResourceAsStream(String resourceName, Class callingClass) {
        URL url = PropertiesLoader.getResource(resourceName, callingClass);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    private static URL getResource(String resourceName, Class callingClass) {
        URL url = null;
        url = Thread.currentThread().getContextClassLoader().getResource(resourceName);
        if (url == null) {
            url = PropertiesLoader.class.getClassLoader().getResource(resourceName);
        }
        if (url == null) {
            url = callingClass.getClassLoader().getResource(resourceName);
        }
        return url;
    }
}

