/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.api.search.query;

import com.atlassian.sal.api.search.parameter.BasicSearchParameter;
import com.atlassian.sal.api.search.parameter.SearchParameter;
import com.atlassian.sal.api.search.query.QueryParser;
import com.atlassian.sal.api.util.URIUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultQueryParser
implements QueryParser {
    private static final Logger log = Logger.getLogger(DefaultQueryParser.class);
    private String searchString;
    private Map<String, SearchParameter> queryParameters = new HashMap<String, SearchParameter>();

    public DefaultQueryParser(String queryString) {
        if (StringUtils.isEmpty((String)queryString)) {
            throw new IllegalArgumentException("Cannot parse empty query string!");
        }
        this.parseQueryString(queryString);
    }

    public String getSearchString() {
        return this.searchString;
    }

    public int getMaxHits() {
        int maxHits = -1;
        String maxHitsString = this.getParameterValue("maxhits");
        if (maxHitsString != null) {
            try {
                maxHits = Integer.parseInt(maxHitsString);
            }
            catch (NumberFormatException e) {
                log.error((Object)("Invalid maxhits parameter received: '" + maxHitsString + "'"));
            }
        }
        return maxHits;
    }

    public Set<SearchParameter> getParameters() {
        return new HashSet<SearchParameter>(this.queryParameters.values());
    }

    public SearchParameter getParameter(String parameterName) {
        return this.queryParameters.get(parameterName);
    }

    public String getParameterValue(String parameterName) {
        if (!this.queryParameters.containsKey(parameterName)) {
            return null;
        }
        return this.queryParameters.get(parameterName).getValue();
    }

    private void parseQueryString(String queryString) {
        if (queryString.indexOf("&") == -1) {
            this.searchString = URIUtil.decode(queryString);
        }
        String[] strings = queryString.split("&");
        this.searchString = URIUtil.decode(strings[0]);
        for (int i = 1; i < strings.length; ++i) {
            String string = strings[i];
            BasicSearchParameter searchParam = new BasicSearchParameter(string);
            this.queryParameters.put(searchParam.getName(), searchParam);
        }
    }
}

