/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.api.http.httpclient;

import com.atlassian.sal.api.http.HttpRequest;
import com.atlassian.sal.api.http.httpclient.HttpClientAuthenticator;
import com.atlassian.sal.api.http.httpclient.HttpClientHttpRequest;
import com.atlassian.security.auth.trustedapps.EncryptedCertificate;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;

final class TrustedTokenAuthenticator
extends HttpClientAuthenticator {
    private final EncryptedCertificate userCertificate;

    TrustedTokenAuthenticator(EncryptedCertificate userCertificate) {
        this.userCertificate = userCertificate;
    }

    public HttpMethod makeMethod(HttpRequest request) {
        HttpMethod method = HttpClientHttpRequest.createMethod(request.getUrl(), request);
        if (this.userCertificate != null && this.userCertificate.getID() != null && !"".equals(this.userCertificate.getID().trim())) {
            method.setRequestHeader("X-Seraph-Trusted-App-ID", this.userCertificate.getID());
            method.setRequestHeader("X-Seraph-Trusted-App-Key", this.userCertificate.getSecretKey());
            method.setRequestHeader("X-Seraph-Trusted-App-Cert", this.userCertificate.getCertificate());
        }
        return method;
    }

    public TrustedConnectionStatus getTrustedConnectionStatus(HttpMethod httpMethod) {
        if (!httpMethod.hasBeenUsed()) {
            throw new IllegalStateException("Method has not been executed");
        }
        if (!TrustedTokenAuthenticator.isTrustedConnectionRequest(httpMethod)) {
            return null;
        }
        return this.buildStatus(httpMethod);
    }

    private static boolean isTrustedConnectionRequest(HttpMethod method) {
        return method.getRequestHeader("X-Seraph-Trusted-App-ID") != null;
    }

    private TrustedConnectionStatus buildStatus(HttpMethod httpMethod) {
        boolean trustSupported;
        Header[] statusHeaders = httpMethod.getResponseHeaders("X-Seraph-Trusted-App-Status");
        boolean bl = trustSupported = statusHeaders != null && statusHeaders.length != 0;
        if (!trustSupported) {
            return TrustedConnectionStatus.UNSUPPORTED;
        }
        Header[] headers = httpMethod.getResponseHeaders("X-Seraph-Trusted-App-Error");
        if (headers == null || headers.length == 0) {
            return TrustedConnectionStatus.SUCCESS;
        }
        TrustedConnectionStatusBuilder builder = new TrustedConnectionStatusBuilder();
        for (Header header : headers) {
            builder.addTrustedConnectionError(header.getValue());
        }
        return builder.getStatus();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class TrustedConnectionStatus {
        public static final TrustedConnectionStatus UNSUPPORTED = new TrustedConnectionStatus(false, false, false, Collections.<String>emptyList(), false);
        public static final TrustedConnectionStatus SUCCESS = new TrustedConnectionStatus(true, true, false, Collections.<String>emptyList(), true);
        private final boolean userRecognized;
        private final boolean appRecognized;
        private final boolean trustedConnectionError;
        private final List<String> trustedConnectionErrors;
        private final boolean trustSupported;

        private TrustedConnectionStatus(boolean userRecognized, boolean appRecognized, boolean trustedConnectionError, List<String> trustedConnectionErrors, boolean trustSupported) {
            this.userRecognized = userRecognized;
            this.appRecognized = appRecognized;
            this.trustedConnectionError = trustedConnectionError;
            this.trustedConnectionErrors = Collections.unmodifiableList(new LinkedList<String>(trustedConnectionErrors));
            this.trustSupported = trustSupported;
        }

        public boolean isUserRecognized() {
            return this.userRecognized;
        }

        public boolean isAppRecognized() {
            return this.appRecognized;
        }

        public boolean isTrustedConnectionError() {
            return this.trustedConnectionError;
        }

        public List<String> getTrustedConnectionErrors() {
            return this.trustedConnectionErrors;
        }

        public boolean isTrustSupported() {
            return this.trustSupported;
        }

        public String toString() {
            if (!this.trustSupported) {
                return "Trusted connection not supported";
            }
            if (!this.trustedConnectionError) {
                return "Trusted connection successful";
            }
            return "Trusted connection errors: " + this.trustedConnectionErrors;
        }
    }

    private static class TrustedConnectionStatusBuilder {
        private final List<String> trustedConnectionErrors = new LinkedList<String>();
        private static final String UNRECOGNIZED_APP = "Unrecognized application";
        private static final String UNRECOGNIZED_USER = "Unrecognized user";

        private TrustedConnectionStatusBuilder() {
        }

        public TrustedConnectionStatusBuilder addTrustedConnectionError(String error) {
            this.trustedConnectionErrors.add(error);
            return this;
        }

        public TrustedConnectionStatus getStatus() {
            if (this.trustedConnectionErrors.isEmpty()) {
                return TrustedConnectionStatus.SUCCESS;
            }
            boolean appRecognized = !this.trustedConnectionErrors.contains(UNRECOGNIZED_APP);
            boolean userRecognized = appRecognized && !this.trustedConnectionErrors.contains(UNRECOGNIZED_USER);
            return new TrustedConnectionStatus(userRecognized, appRecognized, true, this.trustedConnectionErrors, true);
        }
    }
}

