/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.api.http.httpclient;

import com.atlassian.sal.api.http.Authenticator;
import com.atlassian.sal.api.http.HttpParameters;
import com.atlassian.sal.api.http.HttpRequest;
import com.atlassian.sal.api.http.HttpResponse;
import com.atlassian.sal.api.http.HttpRetrievalService;
import com.atlassian.sal.api.http.httpclient.HttpClientAuthenticator;
import com.atlassian.sal.api.http.httpclient.HttpClientHttpRequest;
import com.atlassian.sal.api.http.httpclient.HttpClientHttpResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Map;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Category;

public final class HttpClientHttpRetrievalService
implements HttpRetrievalService {
    private static final Category log = Category.getInstance(HttpClientHttpRetrievalService.class);
    private static final int MAX_ATTEMPTS = 3;

    public HttpResponse get(HttpRequest httpRequest) throws IOException {
        HttpParameters httpParameters = httpRequest.getHttpParameters();
        if (!httpParameters.isEnabled()) {
            throw new IOException("External connections have been disabled");
        }
        URL remoteUrl = new URL(httpRequest.getUrl());
        HttpClient client = new HttpClient();
        this.configureProxy(client, remoteUrl);
        this.setClientParameters(client, httpParameters);
        boolean retry = true;
        int attempt = 0;
        HttpClientHttpResponse response = null;
        while (retry) {
            ++attempt;
            HttpMethod method = this.makeMethod(httpRequest);
            try {
                boolean bl = retry = this.executeMethod(client, method, httpRequest, attempt) == ExecuteResult.RETRY;
                if (retry) {
                    method.releaseConnection();
                    continue;
                }
                response = new HttpClientHttpResponse(httpRequest, method);
            }
            catch (RuntimeException e) {
                method.releaseConnection();
                throw e;
            }
            catch (IOException e) {
                method.releaseConnection();
                log.info((Object)("Failed to download " + httpRequest.getUrl()), (Throwable)e);
                throw new IOException("Failed to download " + httpRequest.getUrl() + ": " + e.getMessage());
            }
        }
        return response;
    }

    private ExecuteResult executeMethod(HttpClient client, HttpMethod method, HttpRequest httpRequest, int attempt) throws IOException {
        int statusCode;
        if (attempt > 3) {
            throw new IOException("Maximum retries exceeded");
        }
        if (httpRequest.getAuthenticator() != null && httpRequest.getAuthenticator() instanceof HttpClientAuthenticator) {
            ((HttpClientAuthenticator)httpRequest.getAuthenticator()).preprocess(client, method);
        }
        if (method instanceof PutMethod && httpRequest.getRequestBody() != null) {
            ((PutMethod)method).setRequestEntity((RequestEntity)new InputStreamRequestEntity((InputStream)new ByteArrayInputStream(httpRequest.getRequestBody().getBytes("UTF-8")), httpRequest.getRequestContentType() + "; charset=UTF-8"));
        }
        if ((statusCode = client.executeMethod(method)) >= 300 && statusCode <= 399) {
            Header locationHeader = method.getResponseHeader("location");
            if (locationHeader != null) {
                String redirectLocation = locationHeader.getValue();
                httpRequest.setUrl(redirectLocation);
                return ExecuteResult.RETRY;
            }
            throw new IOException("HTTP response returned redirect code " + statusCode + " but did not provide a location header");
        }
        return ExecuteResult.COMPLETE;
    }

    private void configureProxy(HttpClient client, URL remoteUrl) {
        String proxyHost = System.getProperty("http.proxyHost");
        if (proxyHost != null && !this.isNonProxyHost(remoteUrl.getHost())) {
            int port = 80;
            try {
                port = Integer.parseInt(System.getProperty("http.proxyPort", "80"));
            }
            catch (NumberFormatException e) {
                log.warn((Object)"System property 'http.proxyPort' is not a number. Defaulting to 80.");
            }
            client.getHostConfiguration().setProxy(proxyHost, port);
            if (this.proxyAuthenticationRequired()) {
                client.getState().setProxyCredentials(new AuthScope(proxyHost, port), (Credentials)new UsernamePasswordCredentials(System.getProperty("http.proxyUser"), System.getProperty("http.proxyPassword")));
            }
        }
    }

    private String getVersionNumber() {
        return "test version";
    }

    private void setClientParameters(HttpClient client, HttpParameters connectionParameters) {
        HttpConnectionManagerParams params = client.getHttpConnectionManager().getParams();
        params.setSoTimeout(connectionParameters.getSocketTimeout());
        params.setConnectionTimeout(connectionParameters.getConnectionTimeout());
    }

    private boolean proxyAuthenticationRequired() {
        return System.getProperty("http.proxyUser") != null;
    }

    private boolean isNonProxyHost(String host) {
        String[] nonProxyHosts;
        String httpNonProxyHosts = System.getProperty("http.nonProxyHosts");
        if (StringUtils.isBlank((String)httpNonProxyHosts)) {
            if (StringUtils.isBlank((String)System.getProperty("http.nonProxyHost"))) {
                log.warn((Object)"The system property http.nonProxyHost is set. You probably meant to set http.nonProxyHosts.");
            }
            return false;
        }
        for (String nonProxyHost : nonProxyHosts = httpNonProxyHosts.split("\\|")) {
            if (!(nonProxyHost.startsWith("*") ? host.endsWith(nonProxyHost.substring(1)) : host.equals(nonProxyHost))) continue;
            return true;
        }
        return false;
    }

    private HttpMethod makeMethod(HttpRequest httpRequest) {
        Authenticator authenticator = httpRequest.getAuthenticator();
        HttpMethod method = authenticator != null && authenticator instanceof HttpClientAuthenticator ? ((HttpClientAuthenticator)authenticator).makeMethod(httpRequest) : HttpClientHttpRequest.createMethod(httpRequest.getUrl(), httpRequest);
        if (method instanceof PostMethod) {
            method.setRequestHeader("Content-type", "application/x-www-form-urlencoded; charset=UTF-8");
            for (Map.Entry entry : httpRequest.getPostParams().entrySet()) {
                ((PostMethod)method).addParameter((String)entry.getKey(), (String)entry.getValue());
            }
        }
        method.setRequestHeader("User-agent", MessageFormat.format("Atlassian/{0} (http://www.atlassian.com/)", this.getVersionNumber()));
        return method;
    }

    public HttpResponse get(String url) throws IOException {
        return this.get(this.getDefaultRequestFor(url));
    }

    public HttpRequest getDefaultRequestFor(String url) {
        HttpRequest request = new HttpRequest();
        request.setMaximumCacheAgeInMillis(524288000L);
        request.setMaximumSize(1800000);
        request.setUrl(url);
        request.setAuthenticator(null);
        request.setHttpParameters(new HttpParameters(10000, 10000, true));
        return request;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ExecuteResult {
        RETRY,
        COMPLETE;

    }
}

