/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.api.http.httpclient;

import com.atlassian.sal.api.http.HttpRequest;
import com.atlassian.sal.api.http.HttpResponse;
import com.atlassian.sal.api.http.SizeLimitedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.HttpMethod;

public final class HttpClientHttpResponse
implements HttpResponse {
    private final HttpRequest request;
    private final HttpMethod method;

    public HttpClientHttpResponse(HttpRequest httpRequest, HttpMethod httpMethod) {
        this.request = httpRequest;
        this.method = httpMethod;
    }

    public final boolean isCached() {
        return false;
    }

    public final boolean isFailed() {
        return this.method == null || this.method.getStatusCode() < 200 || this.method.getStatusCode() > 299;
    }

    public final boolean isNotFound() {
        return this.method.getStatusCode() == 404;
    }

    public final boolean isNotPermitted() {
        return this.method.getStatusCode() == 403 || this.method.getStatusCode() == 401;
    }

    public final InputStream getResponseBody() throws IOException {
        if (this.request.getMaximumSize() > 0) {
            return new SizeLimitedInputStream(this.method.getResponseBodyAsStream(), this.request.getMaximumSize());
        }
        return this.method.getResponseBodyAsStream();
    }

    public final String getContentType() {
        return this.method.getResponseHeader("Content-type").toString();
    }

    public final String getStatusMessage() {
        return this.method.getStatusText();
    }

    public final int getStatusCode() {
        return this.method.getStatusCode();
    }

    public final void finish() {
        this.method.releaseConnection();
    }

    public String getResponseBodyAsString() throws IOException {
        return this.method.getResponseBodyAsString();
    }

    public boolean isSuccessful() {
        return this.method.getStatusCode() == 200;
    }

    public String toString() {
        String response = null;
        try {
            response = this.getResponseBodyAsString();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "Status code: " + this.getStatusCode() + ", ResponseBody: " + response;
    }
}

