/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.api.http.httpclient;

import com.atlassian.sal.api.http.HttpRequest;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.OptionsMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.TraceMethod;

public class HttpClientHttpRequest
extends HttpRequest {
    public HttpMethod createMethod() {
        return HttpClientHttpRequest.createMethod(this.getUrl(), this);
    }

    public static HttpMethod createMethod(String url, HttpRequest request) throws IllegalArgumentException {
        return HttpClientHttpRequest.createMethod(request.getMethodType(), url);
    }

    public static HttpMethod createMethod(HttpRequest.HttpMethodType methodType, String url) {
        HttpMethod method = HttpClientHttpRequest.makeRawMethod(methodType, url);
        method.setRequestHeader("Connection", "close");
        return method;
    }

    private static HttpMethod makeRawMethod(HttpRequest.HttpMethodType methodType, String url) {
        switch (methodType) {
            case DELETE: {
                return new DeleteMethod(url);
            }
            case GET: {
                return new GetMethod(url);
            }
            case POST: {
                return new PostMethod(url);
            }
            case PUT: {
                return new PutMethod(url);
            }
            case HEAD: {
                return new HeadMethod(url);
            }
            case OPTIONS: {
                return new OptionsMethod(url);
            }
            case TRACE: {
                return new TraceMethod(url);
            }
        }
        throw new IllegalArgumentException("Unknown method type: " + methodType);
    }
}

