/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.api.http.httpclient;

import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.http.Authenticator;
import com.atlassian.sal.api.http.AuthenticatorFactory;
import com.atlassian.sal.api.http.httpclient.BasicAuthenticator;
import com.atlassian.sal.api.http.httpclient.DefaultSeraphAuthenticator;
import com.atlassian.sal.api.http.httpclient.NullAuthenticator;
import com.atlassian.sal.api.http.httpclient.TrustedTokenAuthenticator;
import com.atlassian.sal.api.trusted.CertificateFactory;
import com.atlassian.security.auth.trustedapps.EncryptedCertificate;

public final class HttpClientAuthenticatorFactory
implements AuthenticatorFactory {
    public final Authenticator getBasicAuthenticator(String username, String password) {
        BasicAuthenticator authenticator = new BasicAuthenticator();
        authenticator.setProperty("username", username);
        authenticator.setProperty("password", password);
        return authenticator;
    }

    public final Authenticator getTrustedTokenAuthenticator(String username) {
        if (username == null || "".equals(username)) {
            return new NullAuthenticator();
        }
        CertificateFactory certificateFactory = (CertificateFactory)ComponentLocator.getComponent(CertificateFactory.class);
        EncryptedCertificate certificate = certificateFactory.createCertificate(username);
        return new TrustedTokenAuthenticator(certificate);
    }

    public final Authenticator getSeraphAuthenticator(String username, String password) {
        DefaultSeraphAuthenticator authenticator = new DefaultSeraphAuthenticator();
        authenticator.setProperty("username", username);
        authenticator.setProperty("password", password);
        return authenticator;
    }
}

