/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.api.http;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class SizeLimitedInputStream
extends InputStream {
    private final int maximumLength;
    private final InputStream wrappedInputStream;
    private long currentLength;

    public SizeLimitedInputStream(InputStream wrappedInputStream, int maxBytesToRead) {
        this.wrappedInputStream = new BufferedInputStream(wrappedInputStream);
        this.maximumLength = maxBytesToRead;
    }

    public int read() throws IOException {
        if (++this.currentLength > (long)this.maximumLength) {
            throw new IOException("Too much data retrieved: " + this.currentLength);
        }
        return this.wrappedInputStream.read();
    }

    public long skip(long n) throws IOException {
        if (this.currentLength + n > (long)this.maximumLength) {
            throw new IOException("Too much data retrieved: " + this.currentLength + n);
        }
        long actualSkipped = this.wrappedInputStream.skip(n);
        this.currentLength += actualSkipped;
        return actualSkipped;
    }

    public void close() throws IOException {
        this.wrappedInputStream.close();
    }

    public int available() throws IOException {
        return this.wrappedInputStream.available();
    }

    public synchronized void mark(int readlimit) {
        this.wrappedInputStream.mark(readlimit);
    }

    public synchronized void reset() throws IOException {
        this.wrappedInputStream.reset();
    }

    public boolean markSupported() {
        return this.wrappedInputStream.markSupported();
    }
}

