/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.core.lifecycle;

import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.sal.api.lifecycle.LifecycleManager;
import java.util.Collection;
import org.apache.log4j.Logger;

public abstract class DefaultLifecycleManager
implements LifecycleManager {
    private boolean started = false;
    private static final Logger log = Logger.getLogger(DefaultLifecycleManager.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() {
        if (!this.started && this.isApplicationSetUp()) {
            try {
                this.notifyOnStart();
            }
            finally {
                this.started = true;
            }
        }
    }

    protected void notifyOnStart() {
        Collection listeners = ComponentLocator.getComponents(LifecycleAware.class);
        for (LifecycleAware entry : listeners) {
            try {
                entry.onStart();
            }
            catch (RuntimeException ex) {
                log.error((Object)("Unable to start component: " + entry.getClass().getName()), (Throwable)ex);
            }
        }
    }
}

