/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.api.features;

import com.atlassian.sal.api.features.EnabledDarkFeatures;
import com.atlassian.sal.api.features.FeatureKeyScope;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class EnabledDarkFeaturesBuilder {
    private final Map<FeatureKeyScope, Set<String>> enabledDarkFeatures = new EnumMap<FeatureKeyScope, Set<String>>(FeatureKeyScope.class);

    public EnabledDarkFeaturesBuilder unmodifiableFeaturesEnabledForAllUsers(@Nullable Set<String> enabledFeatureKeys) {
        return this.setEnabledFeatures(FeatureKeyScope.ALL_USERS_READ_ONLY, enabledFeatureKeys);
    }

    public EnabledDarkFeaturesBuilder featuresEnabledForAllUsers(@Nullable Set<String> enabledFeatureKeys) {
        return this.setEnabledFeatures(FeatureKeyScope.ALL_USERS, enabledFeatureKeys);
    }

    public EnabledDarkFeaturesBuilder featuresEnabledForCurrentUser(@Nullable Set<String> enabledFeatureKeys) {
        return this.setEnabledFeatures(FeatureKeyScope.CURRENT_USER_ONLY, enabledFeatureKeys);
    }

    public EnabledDarkFeatures build() {
        return new EnabledDarkFeatures(Collections.unmodifiableMap(this.enabledDarkFeatures));
    }

    private EnabledDarkFeaturesBuilder setEnabledFeatures(FeatureKeyScope featureKeyScope, @Nullable Set<String> enabledFeatureKeys) {
        ImmutableSet nonNullCopy = enabledFeatureKeys != null ? ImmutableSet.copyOf(enabledFeatureKeys) : ImmutableSet.of();
        this.enabledDarkFeatures.put(featureKeyScope, (Set<String>)nonNullCopy);
        return this;
    }
}

