package com.atlassian.sal.api.validate;

import com.google.common.collect.ImmutableSet;

import javax.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

/**
 * The outcome of validating multiple licenses.
 *
 * @since 4.1
 */
public class MultipleLicensesValidationResult {

    private final Collection<LicenseValidationResult> licenseValidationResults;

    public MultipleLicensesValidationResult(@Nonnull final Collection<LicenseValidationResult> licenseValidationResults) {
        this.licenseValidationResults = Collections.unmodifiableCollection(licenseValidationResults);
    }

    /**
     * @return License validation result of each products
     */
    public Collection<LicenseValidationResult> getLicenseValidationResults() {
        return Collections.unmodifiableCollection(licenseValidationResults);
    }

    /**
     * @return true if all the result are valid otherwise false
     */
    public boolean isValid(){
        return licenseValidationResults.stream().allMatch(LicenseValidationResult::isValid);
    }

    /**
     * @return true if at least one result has error otherwise false
     */
    public boolean hasErrors(){
        return licenseValidationResults.stream().anyMatch(res -> res.hasErrors());
    }

    /**
     * @return @return true if at least one result has warning otherwise false
     */
    public boolean hasWarnings(){
        return licenseValidationResults.stream().anyMatch(res -> res.hasWarnings());
    }
}
