/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.api.validate;

import com.atlassian.annotations.PublicApi;
import com.atlassian.sal.api.validate.LicenseValidationError;
import com.atlassian.sal.api.validate.LicenseValidationWarning;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import javax.annotation.Nonnull;

@PublicApi
public class LicenseValidationResult {
    private final String productKey;
    private final ImmutableSet<LicenseValidationError> errorMessages;
    private final ImmutableSet<LicenseValidationWarning> warningMessages;

    private LicenseValidationResult(String productKey, Iterable<LicenseValidationError> errorMessages, Iterable<LicenseValidationWarning> warningMessages) {
        this.productKey = productKey;
        this.errorMessages = ImmutableSet.copyOf(errorMessages);
        this.warningMessages = ImmutableSet.copyOf(warningMessages);
    }

    public static LicenseValidationResult withErrorMessages(@Nonnull String productKey, @Nonnull Iterable<LicenseValidationError> errorMessages) {
        return new LicenseValidationResult(productKey, errorMessages, Collections.emptySet());
    }

    public static LicenseValidationResult withWarningMessages(@Nonnull String productKey, @Nonnull Iterable<LicenseValidationWarning> warningMessages) {
        return new LicenseValidationResult(productKey, Collections.emptySet(), warningMessages);
    }

    public static LicenseValidationResult withErrorAndWarningMessages(@Nonnull String productKey, @Nonnull Iterable<LicenseValidationError> errorMessages, @Nonnull Iterable<LicenseValidationWarning> warningMessages) {
        return new LicenseValidationResult(productKey, errorMessages, warningMessages);
    }

    public boolean isValid() {
        return this.errorMessages.isEmpty();
    }

    public boolean hasErrors() {
        return !this.errorMessages.isEmpty();
    }

    public boolean hasWarnings() {
        return !this.warningMessages.isEmpty();
    }

    @Nonnull
    public Iterable<LicenseValidationError> getErrorMessages() {
        return this.errorMessages;
    }

    @Nonnull
    public Iterable<LicenseValidationWarning> getWarningMessages() {
        return this.warningMessages;
    }
}

