package com.atlassian.sal.api.validate;

import com.atlassian.annotations.PublicApi;

import javax.annotation.Nonnull;
import java.util.Set;

/**
 * The outcome of a licenses validation check.
 * @since 4.1
 */
public class MultipleLicensesValidationResult {

    private final Set<LicenseValidationResult> licenseValidationResults;

    public MultipleLicensesValidationResult(@Nonnull final Set<LicenseValidationResult> licenseValidationResults) {
        this.licenseValidationResults = licenseValidationResults;
    }

    /**
     * @return License validation result of each products
     */
    public Set<LicenseValidationResult> getLicenseValidationResults() {
        return licenseValidationResults;
    }
}
