package com.atlassian.sal.api.validate;

import javax.annotation.Nonnull;

/**
 * The license validation error details.
 *
 * @since 4.1
 */
public class LicenseValidationError {

    private final LicenseErrorCode licenseErrorCode;

    private final String errorMessage;

    public LicenseValidationError(@Nonnull final LicenseErrorCode licenseErrorCode, String errorMessage) {
        this.licenseErrorCode = licenseErrorCode;
        this.errorMessage = errorMessage;
    }

    /**
     * @return The error type.
     */
    @Nonnull
    public LicenseErrorCode getLicenseErrorCode() {
        return licenseErrorCode;
    }

    /**
     * These should normally be localised to the end user's locale.
     *
     * @return Warning message to explain what is wrong.
     */
    @Nonnull
    public String getErrorMessage() {
        return errorMessage;
    }
}
