package com.atlassian.sal.api.validate;

/**
 * All error types of the license verification's result.
 *
 * @since 4.1
 */
public enum LicenseErrorCode {

    UNKNOWN,

    /**
     * Invalid product key value.
     */
    INVALID_PRODUCT_KEY,

    /**
     * The license is invalid.
     */
    INVALID_LICENSE_KEY,

    /**
     * The license is not for the selected product.
     */
    WRONG_PRODUCT,

    /**
     * The license is expired.
     */
    LICENSE_EXPIRED,

    /**
     * The license does not match with other licenses or it does not incompatible with the environment.
     */
    INCOMPATIBLE,

    /**
     * The license does not has the number of users/seats set
     */
    USER_LIMIT_ISNOT_SET
}
