package com.atlassian.sal.api.license;

import com.atlassian.annotations.PublicApi;

import javax.annotation.Nonnull;
import java.util.Optional;

/**
 * Interface for the product license detail in a string format
 * @since 4.1
 */
public interface RawProductLicense {

    /**
     * @return The product to add this license to e.g."jira-software", "jira-servicedesk", "jira-core"
     */
    @Nonnull
    String getProductKey();

    /**
     * @return The license string
     */
    @Nonnull
    Optional<String> getLicense();

}
