package com.atlassian.sal.api.auth;

/**
 * Used to store whether a request has successfully passed through the OAuth filter in some way.
 * Specifically, this can be used to check if a 2LO request without a user associated with it (e.g. impersonation is
 * disabled) came from a trusted system.
 */
public class OAuthRequestVerifierImpl implements OAuthRequestVerifier
{
    private static final ThreadLocal<Boolean> isVerified = new ThreadLocal<Boolean>();

    public boolean isVerified()
    {
        return Boolean.TRUE.equals(isVerified.get());
    }

    public void setVerified(boolean val)
    {
        isVerified.set(val);
    }

    public void clear()
    {
        isVerified.remove();
    }
}
