package com.atlassian.sal.api.auth;

/**
 * Used to store whether a request has successfully passed through the OAuth filter in some way.
 * Specifically, this can be used to check if a 2LO request without a user associated with it (e.g. impersonation is
 * disabled) came from a trusted system.
 */
public class Verifier
{
    private static final ThreadLocal < Boolean > isVerified = new ThreadLocal < Boolean > ()
    {
        @Override
        protected Boolean initialValue()
        {
            return false;
        }
    };

    public static boolean isVerified()
    {
        Boolean val = isVerified.get();
        if (val != null)
        {
            return val;
        }
        return false;
    }

    public static void setVerified(boolean val)
    {
        isVerified.set(val);
    }

    public static void clear()
    {
        isVerified.remove();
    }
}
