package com.atlassian.sal.api.features;

import com.atlassian.sal.api.component.ComponentLocator;

/**
 * Provides static access to methods on DarkFeatureManager for dependency-injection-free use.
 */
public class DarkFeatures
{
    private static DarkFeatureManager darkFeatureManager;

    public static boolean isSystemDarkFeatureEnabled(String darkFeatureSystemPropertyKey)
    {
        return getDarkFeatureManager().isSystemDarkFeatureEnabled(darkFeatureSystemPropertyKey);
    }

    public static boolean isUserDarkFeatureEnabled(String darkFeatureSystemPropertyKey)
    {
        return getDarkFeatureManager().isUserDarkFeatureEnabled(darkFeatureSystemPropertyKey);
    }

    private static DarkFeatureManager getDarkFeatureManager()
    {
        if (darkFeatureManager == null)
        {
            darkFeatureManager = ComponentLocator.getComponent(DarkFeatureManager.class);
        }
        return darkFeatureManager;
    }

}
