package com.atlassian.sal.api.features;

/**
 * Provides a cross-product method for determining whether a dark feature is enabled.
 *
 * Implementing products can back these checks with their own internal dark feature management system, but must follow
 * the enable and disable dark features on startup based on system properties and the contents of an optional properties file.
 *
 * Dark feature keys must begin with atlassian.darkfeature. Values must be either true or false.
 * Location of dark features property file can be overridden with darkfeatures.properties.file system property.
 *
 * See SystemDarkFeatureInitializer in sal-core for implementation.
 */
public interface DarkFeatureManager
{
    /**
     * Checks if a dark feature is enabled
     * @param darkFeatureSystemPropertyKey key of the feature to be checked
     * @return true if enabled, false otherwise
     */
    public boolean isSystemDarkFeatureEnabled(String darkFeatureSystemPropertyKey);

    /**
     * Checks if a dark feature is enabled for the current user (must be called within the context of a request)
     * @param darkFeatureSystemPropertyKey key of the feature to be checked
     * @return true if enabled, false otherwise
     */
    public boolean isUserDarkFeatureEnabled(String darkFeatureSystemPropertyKey);
}
