package com.atlassian.sal.api.events;

import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.servlet.http.HttpSessionListener;

/**
 * Represents an event published when a http session is destroyed.  Implementers should fire this event accordingly.
 * @see HttpSessionListener
 */
@Immutable
public class SessionDestroyedEvent
{
    private final String sessionId;
    private final String userName;

    private SessionDestroyedEvent(final String sessionId, final String userName)
    {
        this.sessionId = sessionId;
        this.userName = userName;
    }

    public static Builder builder()
    {
        return new Builder();
    }

    public String getSessionId()
    {
        return sessionId;
    }

    @Nullable
    public String getUserName()
    {
        return userName;
    }

    public static class Builder
    {
        private String sessionId;
        private String userName;

        private Builder()
        {
        }

        public Builder sessionId(final String sessionId)
        {
            if (sessionId == null)
            {
                throw new NullPointerException("Session ID must be supplied");
            }
            this.sessionId = sessionId;
            return this;
        }

        public Builder userName(@Nullable final String userName)
        {
            this.userName = userName;
            return this;
        }


        public SessionDestroyedEvent build()
        {
            if (sessionId == null)
            {
                throw new NullPointerException("Session ID must be supplied");
            }
            return new SessionDestroyedEvent(sessionId, userName);
        }
    }

}

